/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.property.Propertized;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.property.PropertyDefinitions;
import cz.insophy.inplan.property.PropertySupport;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.InPlanMatReqStoreActivity;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.store.TransactionStoreActivityTarget;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.Identifiable;
import cz.insophy.inplan.util.UserSelectable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public abstract class MaterialRequest
implements StoreActivityOwner,
TransactionStoreActivityTarget,
UserSelectable,
Propertized,
Identifiable {
    private final String id;
    protected InPlanMatReqStoreActivity storeAct;
    private List<InPlanMatReqStoreActivity> storeActList;
    private boolean userSelected = false;
    private double qtyOffset = 0.0;
    private long timeOffset = 0L;
    private PropertySupport propertySupport;

    public MaterialRequest(String id, long time, Material material, double saQty) {
        Preconditions.checkNotNull(id, "ID of material request cannot be null.");
        Preconditions.checkNotNull(material, "Material in material request cannot be null.");
        Preconditions.checkArgument(GeneralizedRequest.isDateValid(time), "Time of material request must be valid.");
        this.id = id;
        this.storeAct = new InPlanMatReqStoreActivity(StoreType.INPLAN_ACTUAL, time, material, saQty, this);
        this.storeActList = Collections.singletonList(this.storeAct);
        this.propertySupport = new PropertySupport();
    }

    public InPlanStoreActivity getStoreActivity() {
        return this.storeAct;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    public Material getMaterial() {
        return this.storeAct.getMaterial();
    }

    public abstract double getQty();

    public abstract void setQty(double var1);

    protected void setSaQty(double qty) {
        this.qtyOffset = 0.0;
        Plan plan = this.getPlan();
        this.removeSaFromPlan();
        this.storeAct.setQty(qty);
        this.addSaToPlan(plan);
    }

    public double getQtyOffset() {
        return this.qtyOffset;
    }

    public void setQtyOffset(double offset) {
        this.setQty(this.getQty() + offset - this.qtyOffset);
        this.qtyOffset = offset;
    }

    public void setQtyOffsetOnly(double offset) {
        this.qtyOffset = offset;
    }

    public void setTimeOffsetOnly(long offset) {
        this.timeOffset = offset;
    }

    public void setQtyWithOffset(double qty) {
        double offset = qty - this.getQty();
        this.setQty(qty);
        this.qtyOffset = offset;
    }

    public void setTimeWithOffset(long time) {
        long offset = time - this.getTime();
        this.setTime(time);
        this.timeOffset = offset;
    }

    public long getTime() {
        return this.storeAct.getTime();
    }

    public void setTime(long time) {
        this.timeOffset = 0L;
        Plan plan = this.getPlan();
        this.removeSaFromPlan();
        this.storeAct.setTime(time);
        this.addSaToPlan(plan);
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(long offset) {
        this.setTime(this.getTime() + offset - this.timeOffset);
        this.timeOffset = offset;
    }

    public Plan getPlan() {
        return this.storeAct.getPlan();
    }

    @Override
    public void setPlan(Plan plan) {
        this.removeSaFromPlan();
        this.addSaToPlan(plan);
    }

    protected void removeSaFromPlan() {
        Plan plan = this.storeAct.getPlan();
        if (plan != null) {
            plan.removeActivity(this.storeAct);
        }
    }

    protected void addSaToPlan(Plan plan) {
        if (plan != null) {
            plan.addActivity(this.storeAct);
        }
    }

    public List<InPlanMatReqStoreActivity> getStoreActivities() {
        return this.storeActList;
    }

    @Override
    public boolean isUserSelected() {
        return this.userSelected;
    }

    @Override
    public void setUserSelected(boolean selected) {
        this.userSelected = selected;
    }

    @Override
    public void setProperties(Map<PropertyDefinition, String> properties, @Nonnull PropertyDefinitions definitions) {
        this.propertySupport.setProperties(this.getClass(), properties, definitions);
    }

    @Override
    public void resetProperties(@Nonnull Map<PropertyDefinition, Object> properties) {
        this.propertySupport.resetProperties(this.getClass(), properties);
    }

    @Override
    public void setProperty(@Nonnull PropertyDefinition pd, Object value) {
        this.propertySupport.setProperty(this.getClass(), pd, value);
    }

    @Override
    public Object getProperty(@Nonnull String name) {
        return this.propertySupport.getProperty(name);
    }

    @Override
    public Object getProperty(@Nonnull PropertyDefinition def) {
        return this.propertySupport.getProperty(this.getClass(), def);
    }

    @Override
    @Nonnull
    public Map<PropertyDefinition, Object> getProperties() {
        return this.propertySupport.getProperties();
    }
}

